﻿using QualityManagement.Helper;
using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditResponseLog
{
    public Guid Id { get; set; }
    public Guid AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public Guid? QuestionId { get; set; }
    [ForeignKey("QuestionId")]
    public AuditTemplateQuestion Question { get; set; }
    public string Response { get; set; }
    public Guid? NonConformanceId { get; set; }
    [ForeignKey("NonConformanceId")]
    public NonConformance NonConformance { get; set; }
    public Guid? CapaRequestId { get; set; }
    [ForeignKey("CapaRequestId")]
    public CapaRequest CapaRequest { get; set; }
    public AUDIT_STATUS Status { get; set; }
    public LogStatus LogStatus { get; set; }
    public Guid CreatedBy { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
    public DateTime CreatedDate { get; set; } = DateTime.UtcNow;
}
