﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class AuditTemplateQuestion : BaseEntity
{
    public Guid Id { get; set; }
    public Guid AuditTemplateId { get; set; }
    [ForeignKey("AuditTemplateId")]
    public AuditTemplate AuditTemplate { get; set; }
    public AUDIT_TEMPLATE_SECTION Section { get; set; }
    public int MaxScore { get; set; }
    public string Question { get; set; }
    public string Description { get; set; }
    public AUDIT_TEMPLATE_QUESTION_TYPE InputType { get; set; }
    public bool RequiredEvidence { get; set; }
    public int OrderNo { get; set; }
    public ICollection<QuestionOption> QuestionOptions { get; set; } = new List<QuestionOption>();

}

public enum AUDIT_TEMPLATE_QUESTION_TYPE
{
    YES_NO = 0,
    SINGLE_SELECT = 1,
    MULTI_SELECT = 2,
    TEXT = 3,
    NUMBER = 4,
    FILE = 5,
    RATING = 6,
    DATE = 7
}

public enum AUDIT_TEMPLATE_SECTION
{
    NONE = 0,
    GENERAL = 1,
    PROCESS = 2,
    PRODUCT = 3,
    SUPPLIER = 4,
    OTHER = 5
}


