﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class CapaRequestLog
{
    public Guid Id { get; set; }
    public Guid CapaRequestId { get; set; }
    public string ReferenceNo { get; set; } //Auto_Generated_Number
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid? RaisedById { get; set; }
    [ForeignKey("RaisedById")]
    public User RaisedBY { get; set; }
    public Guid? NonConformanceId { get; set; }
    [ForeignKey("NonConformanceId")]
    public NonConformance NonConformance { get; set; }
    public Guid? AuditId { get; set; }
    [ForeignKey("AuditId")]
    public Audit Audit { get; set; }
    public LogStatus LogStatus { get; set; }
    public CapaRequestStatus CapaRequestStatus { get; set; }
    public CapaRequestPriority Priority { get; set; }
    public DateTime? DueDate { get; set; }
    public Guid CreatedBy { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
    public DateTime CreatedDate { get; set; } = DateTime.UtcNow;
}
