﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//Tracks each customer or internal complaint.
public class Complaint : BaseEntity
{
    public Guid Id { get; set; }
    public string ComplaintNo { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public DateTime ComplaintDate { get; set; }
    public ReportedByEnum ReportedBy { get; set; }
    public Guid? AssignedToId { get; set; }
    [ForeignKey("AssignedToId")]
    public User AssignedTo { get; set; }
    public Guid ComplaintTypeId { get; set; }
    [ForeignKey("ComplaintTypeId")]
    public ComplaintType ComplaintType { get; set; }
    public ComplaintPriorityEnum Priority { get; set; }
    public ComplaintStatusEnum Status { get; set; }
    public string ResolutionSummary { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedUser { get; set; }
    [ForeignKey("ModifiedBy")]
    public User ModifiedUser { get; set; }

    public ICollection<ComplaintAction> ComplaintActions { get; set; } = new List<ComplaintAction>();
    public ICollection<ComplaintComment> ComplaintComments { get; set; } = new List<ComplaintComment>();
    public ICollection<ComplaintRootCause> ComplaintRootCauses { get; set; } = new List<ComplaintRootCause>();
    public ICollection<ComplaintInvestigation> ComplaintInvestigations { get; set; } = new List<ComplaintInvestigation>();
    public ICollection<ComplaintAttachment> ComplaintAttachments { get; set; } = new List<ComplaintAttachment>();

}
