﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class ComplaintAction
{
    public Guid Id { get; set; }
    public Guid ComplaintId { get; set; }
    [ForeignKey("ComplaintId")]
    public Complaint Complaint { get; set; }
    public string ActionTitle { get; set; }
    public string ActionDetail { get; set; }
    public DateTime ActionDate { get; set; }
    public Guid ResponsibleId { get; set; } // Could be a user ID or name
    [ForeignKey("ResponsibleId")]
    public User Responsible { get; set; }
    public ComplaintStatusEnum Status { get; set; } // e.g., "Pending", "Completed", "In Progress"
    public DateTime? DueDate { get; set; } // Optional due date for the action
    public DateTime? CompletedDate { get; set; }
}
