﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
//Investigation details related to a complaint.
public class ComplaintInvestigation
{
    public Guid Id { get; set; }
    public Guid ComplaintId { get; set; }
    // Navigation property
    [ForeignKey("ComplaintId")]
    public Complaint Complaint { get; set; }
    public Guid InvestigatorId { get; set; }
    [ForeignKey("InvestigatorId")]
    public User Investigator { get; set; }
    public DateTime InvestigationDate { get; set; }
    public string Findings { get; set; }
    public string Recommendations { get; set; }
    public ComplaintStatusEnum Status { get; set; } // e.g., "Pending", "Completed", "Escalated"
    public DateTime? FollowUpDate { get; set; }
    public bool ActionRequired { get; set; }
}
