﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class ComplaintRootCause
{
    public Guid Id { get; set; }
    public Guid ComplaintId { get; set; }
    // Navigation property
    [ForeignKey("ComplaintId")]
    public Complaint Complaint { get; set; }
    public string MethodUsed { get; set; }
    public string CauseDescription { get; set; }
    public Guid CreatedById { get; set; }
    [ForeignKey("CreatedById")]
    public User CreatedBy { get; set; }
    public DateTime CreatedAt { get; set; }

}
