﻿using System;
using System.Collections.Generic;

namespace QualityManagement.Data;

public class CourseSessionMedia : BaseEntity
{
    public Guid Id { get; set; }
    public Guid CourseSessionId { get; set; }
    public string Name { get; set; }
    public string Description { get; set; }
    public string Url { get; set; }
    public CourseSessionMediaType MediaType { get; set; }
    public StorageType StorageType { get; set; }
    public Guid? StorageSettingId { get; set; }
    public string Extension { get; set; }
    public bool IsChunk { get; set; }
    public bool IsAllChunkUploaded { get; set; }
    public byte[] Key { get; set; } = null;
    public byte[] IV { get; set; } = null;
    public CourseSession CourseSession { get; set; }
    public StorageSetting StorageSetting { get; set; }
    public ICollection<CourseSessionMediaChunk> CourseSessionMediaChunks { get; set; }
}
