﻿using QualityManagement.Data.Entities;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data;
public class EmployeeCourse : BaseEntity
{
    public Guid Id { get; set; }
    public Guid EmployeeId { get; set; }
    public Guid CourseId { get; set; }
    public string Link { get; set; }
    [ForeignKey("EmployeeId")]
    public User Employee { get; set; }
    public Course Course { get; set; }
    public DateTime? DueDate { get; set; }
    public EmployeeCourseStatus Status { get; set; }
    public DateTime? CompletedDate { get; set; }
    public EmailStatus EmailStatus { get; set; } = EmailStatus.Pending;
    public List<EmployeeCourseSession> EmployeeCourseSessions { get; set; }
}

public enum EmailStatus
{
    Pending,
    Sent,
    Failed
}
