﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class NonConformanceRespAttachment : BaseEntity
{
    public Guid Id { get; set; }
    public Guid NonConformanceResponseId { get; set; }
    // Navigation property
    [ForeignKey("NonConformanceResponseId")]
    public NonConformanceResponse NonConformanceResponse { get; set; }
    public string FilePath { get; set; }
    public string FileName { get; set; }
    public long FileSize { get; set; }
    public string Extension { get; set; }
    public string Description { get; set; }
    public byte[] Key { get; set; } = null;
    public byte[] IV { get; set; } = null;
    public Guid? StorageSettingId { get; set; }
    public StorageType StorageType { get; set; }
    public bool IsAllChunkUploaded { get; set; }
    public int TotalChunk { get; set; }
    public ICollection<NonConformanceRespAttachmentChunk> NonConformanceRespAttachmentChunks { get; set; } = new List<NonConformanceRespAttachmentChunk>();
}
