﻿using QualityManagement.Data.Entities.RiskManagment;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class Risk : BaseEntity
{
    public Guid Id { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid RiskCategoryId { get; set; }
    [ForeignKey("RiskCategoryId")]
    public RiskCategory RiskCategory { get; set; }
    public int Likelihood { get; set; }// 1-5 scale
    public int Severity { get; set; } // 1-5 scale
    public int RiskScore { get; set; }
    public string RiskLevel { get; set; }
    public RiskStatusEnum Status { get; set; }
    public Guid AssignedToId { get; set; }
    [ForeignKey("AssignedToId")]
    public User AssignedTo { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedUser { get; set; }
    [ForeignKey("ModifiedBy")]
    public User ModifiedUser { get; set; }
    public ICollection<RiskReview> RiskReviews { get; set; }
    public ICollection<RiskControl> RiskControls { get; set; }
    public ICollection<RiskAttachment> RiskAttachments { get; set; }

}
