﻿using QualityManagement.Data.Entities.RiskManagment;
using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class RiskLog
{
    public Guid Id { get; set; }
    public Guid RiskId { get; set; }
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid RiskCategoryId { get; set; }
    [ForeignKey("RiskCategoryId")]
    public RiskCategory RiskCategory { get; set; }
    public int Likelihood { get; set; }// 1-5 scale
    public int Severity { get; set; } // 1-5 scale
    public int RiskScore { get; set; }
    public string RiskLevel { get; set; }
    public LogStatus LogStatus { get; set; }
    public RiskStatusEnum Status { get; set; }
    public Guid AssignedToId { get; set; }
    [ForeignKey("AssignedToId")]
    public User AssignedTo { get; set; }
    public Guid CreatedBy { get; set; }
    [ForeignKey("CreatedBy")]
    public User CreatedByUser { get; set; }
    public DateTime CreatedDate { get; set; } = DateTime.UtcNow;

}
