﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class RiskReview
{
    public Guid Id { get; set; }
    public Guid RiskId { get; set; }
    [ForeignKey("RiskId")]
    public Risk Risk { get; set; }
    public DateTime ReviewDate { get; set; }
    public string ReviewerComments { get; set; }
    public int Likelihood { get; set; } // 1-5 scale
    public int Impact { get; set; } // 1-5 scale
    public int RiskScore { get; set; }
    public Guid ReviewerId { get; set; }
    [ForeignKey("ReviewerId")]
    public User Reviewer { get; set; }
    public string RiskLevel { get; set; }

}
