﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class SupplierCertification
{
    public Guid Id { get; set; }
    public Guid SupplierId { get; set; } // Foreign key to Supplier
    public string CertificationName { get; set; } // Name of the certification
    public string IssuedBy { get; set; } // Organization that issued the certification
    public DateTime IssuedDate { get; set; } // Date when the certification was issued
    public DateTime? ExpiryDate { get; set; } // Date when the certification expires
    public string CertificationNumber { get; set; } // Unique identifier for the certification
    public string Status { get; set; } // Status of the certification (e.g., Active, Expired, Revoked)
    public string FilePath { get; set; } // Navigation property to Supplier
    public string FileName { get; set; }
    [ForeignKey("SupplierId")]
    public Supplier Supplier { get; set; }
}
