﻿using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.Data.Entities;
public class SupplierPerformance
{
    public Guid Id { get; set; }
    public Guid SupplierId { get; set; }
    [ForeignKey("SupplierId")]
    public Supplier Supplier { get; set; }
    public DateTime EvaluationDate { get; set; }
    public string Criteria { get; set; } //	Delivery, Quality, Price, Responsiveness
    public int Score { get; set; } //Out of 100
    public Guid EvaluatedById { get; set; }
    [ForeignKey("EvaluatedById")]
    public User EvaluatedBy { get; set; } //User ID
    public string Remarks { get; set; }

}
