﻿using System;
using System.Collections.Generic;
using Microsoft.AspNetCore.Identity;
using QualityManagement.Data.Entities;

namespace QualityManagement.Data;

public class User : IdentityUser<Guid>
{
    public string FirstName { get; set; }
    public string LastName { get; set; }
    public bool IsDeleted { get; set; }
    public bool IsSuperAdmin { get; set; } = false;
    public string ClientId { get; set; }
    public string ClientSecretHash { get; set; }
    public bool IsSystemUser { get; set; } = false;
    public virtual ICollection<UserClaim> UserClaims { get; set; }
    public virtual ICollection<UserLogin> UserLogins { get; set; }
    public virtual ICollection<UserToken> UserTokens { get; set; }
    public virtual ICollection<UserRole> UserRoles { get; set; }
    public virtual ICollection<DocumentUserPermission> DocumentUserPermissions { get; set; }
    public virtual ICollection<UserNotification> UserNotifications { get; set; }
    public virtual ICollection<CategoryUserPermission> CategoryUserPermissions { get; set; }
    public virtual ICollection<Audit> Audits { get; set; } = new List<Audit>();

    //QualityManagement
    public bool IsActive { get; set; }
    public string ProfilePhoto { get; set; }
    public string Provider { get; set; }
    public string Address { get; set; }
    public DateTime CreatedDate { get; set; }
    public Guid? CreatedBy { get; set; }
    public DateTime ModifiedDate { get; set; }
    public Guid? ModifiedBy { get; set; }
    public DateTime? DeletedDate { get; set; }
    public Guid? DeletedBy { get; set; }
    public UserType UserType { get; set; }
    public Guid? EmployeeId { get; set; }
    public bool IsSignup { get; set; }

}
