﻿




using System;
using System.ComponentModel.DataAnnotations.Schema;
using QualityManagement.Data.Entities;

namespace QualityManagement.Data;

public class UserNotification : BaseEntity
{
    public Guid Id { get; set; }
    public string Message { get; set; }
    public bool IsRead { get; set; }
    public Guid UserId { get; set; }
    [ForeignKey("UserId")]
    public virtual User User { get; set; }
    public Guid? DocumentId { get; set; }
    public Document Document { get; set; }
    public Guid? CategoryId { get; set; }
    [ForeignKey("CategoryId")]
    public Category Category { get; set; }

    public NotificationsType NotificationsType { get; set; }
    public string JsonPayload { get; set; }
}

