﻿using Microsoft.EntityFrameworkCore;
using QualityManagement.Data;
using QualityManagement.Data.Entities;

namespace QualityManagement.Domain;

public static class DefaultEntityMappingExtension
{
    public static void DefalutMappingValue(this ModelBuilder modelBuilder)
    {

        modelBuilder.Entity<DocumentIndex>()
          .Property(b => b.CreatedDate)
          .HasDefaultValueSql("GETUTCDATE()");

        modelBuilder.Entity<Document>()
      .Property(b => b.ModifiedDate)
      .HasDefaultValueSql("GETUTCDATE()");

        modelBuilder.Entity<Category>()
       .Property(b => b.ModifiedDate)
       .HasDefaultValueSql("GETUTCDATE()");

        modelBuilder.Entity<DocumentAuditTrail>()
         .Property(b => b.ModifiedDate)
         .HasDefaultValueSql("GETUTCDATE()");

        modelBuilder.Entity<NLog>()
            .Property(b => b.Logged)
            .HasDefaultValueSql("GETUTCDATE()");
    }

    public static void DefalutDeleteValueFilter(this ModelBuilder modelBuilder)
    {

        modelBuilder.Entity<User>()
            .HasQueryFilter(p => !p.IsDeleted && !p.IsSystemUser);

        modelBuilder.Entity<Role>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Action>()
          .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Page>()
         .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Document>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Category>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Reminder>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<EmailSMTPSetting>()
        .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<StorageSetting>()
       .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CompanyProfile>()
        .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Workflow>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Client>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<FileRequest>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<DocumentMetaTag>()
            .HasQueryFilter(p => !p.IsDeleted);

        //ELearning

        modelBuilder.Entity<Action>()
          .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Page>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<EmailTemplate>()
            .HasQueryFilter(p => !p.IsDeleted);


        modelBuilder.Entity<Course>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CourseSession>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CourseSessionQuiz>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CourseSessionMedia>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<QuizQuestion>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<QuizQuestionOption>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<NonConformance>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<NonConformanceResponse>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CapaRequest>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CapaAction>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<AuditResponseAttachment>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<CapaAttachment>()
            .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Risk>()
        .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<RiskCategory>()
        .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Supplier>()
        .HasQueryFilter(p => !p.IsDeleted);

        modelBuilder.Entity<Complaint>()
            .HasQueryFilter(p => !p.IsDeleted);
    }
}
