﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class GetActionQueryHandlerHandler(
    IActionRepository _actionRepository,
    IMapper _mapper,
    ILogger<GetActionQueryHandlerHandler> _logger
    ) : IRequestHandler<GetActionsByPageQuery, List<ActionDto>>
{
    public async Task<List<ActionDto>> Handle(GetActionsByPageQuery request, CancellationToken cancellationToken)
    {
        try
        {
            var entity = await _actionRepository.All.Where(d => d.PageId == request.PageId).ToListAsync();
            return _mapper.Map<List<ActionDto>>(entity);
        }
        catch (Exception ex)
        {
            _logger.LogError(ex, "Error occurred while getting actions by page ID: {PageId}", request.PageId);
            return [];
        }
    }
}
