﻿using AutoMapper;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetAllActionQueryHandler(
        IActionRepository actionRepository,
        IMapper mapper) : IRequestHandler<GetAllActionQuery, ServiceResponse<List<ActionDto>>>
    {
        public async Task<ServiceResponse<List<ActionDto>>> Handle(GetAllActionQuery request, CancellationToken cancellationToken)
        {
            var entities = await actionRepository.All.OrderBy(c => c.Order).ToListAsync();
            return ServiceResponse<List<ActionDto>>.ReturnResultWith200(mapper.Map<List<ActionDto>>(entities));
        }
    }
}
