﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;

public class UpdateActionCommandHandler(
    IActionRepository _actionRepository,
    IUnitOfWork<QMSDbContext> _uow,
    IMapper _mapper,
    ILogger<UpdateActionCommandHandler> _logger) : IRequestHandler<UpdateActionCommand, ServiceResponse<ActionDto>>
{
    public async Task<ServiceResponse<ActionDto>> Handle(UpdateActionCommand request, CancellationToken cancellationToken)
    {
        var entityExist = await _actionRepository.FindBy(c => c.Name == request.Name && c.Id != request.Id && c.PageId == request.PageId)
            .FirstOrDefaultAsync();
        if (entityExist != null)
        {
            _logger.LogError("Action Name Already Exist.");
            return ServiceResponse<ActionDto>.Return409("Action Name Already Exist.");
        }
        entityExist = await _actionRepository.FindBy(v => v.Id == request.Id).FirstOrDefaultAsync();

        if (entityExist == null)
        {
            _logger.LogError("Action Not Found.");
            return ServiceResponse<ActionDto>.Return404("Action Not Found.");
        }

        entityExist.Name = request.Name;
        entityExist.Order = request.Order;
        entityExist.Code = request.Code;
        _actionRepository.Update(entityExist);

        if (await _uow.SaveAsync() <= 0)
        {
            return ServiceResponse<ActionDto>.Return500();
        }

        var entityDto = _mapper.Map<ActionDto>(entityExist);
        return ServiceResponse<ActionDto>.ReturnResultWith200(entityDto);
    }
}
