﻿using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using MediatR;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteAllowFileExtensionCommandHandler(IAllowFileExtensionRepository _allowFileExtensionRepository, IUnitOfWork<QMSDbContext> _uow) : IRequestHandler<DeleteAllowFileExtensionCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteAllowFileExtensionCommand request, CancellationToken cancellationToken)
        {
            var extension = await _allowFileExtensionRepository.FindAsync(request.Id);
            if (extension == null)
            {
                return ServiceResponse<bool>.Return404();
            }
            _allowFileExtensionRepository.Remove(extension);
            if (await _uow.SaveAsync() <= 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
    }
}

