﻿using System;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class AddUpdateArchiveRetentionCommandHandler(IUnitOfWork<QMSDbContext> _uow, IArchiveRetentionRepository archiveRetentionRepository) : IRequestHandler<AddUpdateArchiveRetentionCommand, bool>
{
    public async Task<bool> Handle(AddUpdateArchiveRetentionCommand request, CancellationToken cancellationToken)
    {
        var archiveRetention = await archiveRetentionRepository.All.FirstOrDefaultAsync();
        if (archiveRetention != null)
        {
            archiveRetention.RetentionPeriodInDays = request.RetentionPeriodInDays;
            archiveRetention.IsEnabled = request.IsEnabled;
            archiveRetentionRepository.Update(archiveRetention);
        }
        else
        {
            archiveRetention = new Data.Entities.ArchiveRetention
            {
                Id = Guid.NewGuid(),
                RetentionPeriodInDays = request.RetentionPeriodInDays,
                IsEnabled = request.IsEnabled
            };
            archiveRetentionRepository.Add(archiveRetention);
        }
        if (await _uow.SaveAsync() <= 0)
        {
            return false;
        }
        return true;
    }
}
