﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetArchiveRetentionCommandHandler(IArchiveRetentionRepository archiveRetentionRepository) : IRequestHandler<GetArchiveRetentionCommand, ArchiveRetentionDto>
{
    public async Task<ArchiveRetentionDto> Handle(GetArchiveRetentionCommand request, CancellationToken cancellationToken)
    {
        var archiveRetention = archiveRetentionRepository.All.FirstOrDefault();
        if (archiveRetention != null)
        {
            return new ArchiveRetentionDto
            {
                RetentionPeriodInDays = archiveRetention.RetentionPeriodInDays,
                Id = archiveRetention.Id,
                IsEnabled = archiveRetention.IsEnabled
            };
        }
        return null;
    }
}
