﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAuditStatusOverviewCommandHandler(
    IAuditRepository auditRepository,
    ILogger<GetAuditStatusOverviewCommandHandler> logger) : IRequestHandler<GetAuditStatusOverviewCommand, List<NameCountDto>>
{
    public async Task<List<NameCountDto>> Handle(GetAuditStatusOverviewCommand request, CancellationToken cancellationToken)
    {
        try
        {
            IQueryable<Audit> capaRequests;

            if (request.FromDate.HasValue && request.ToDate.HasValue)
            {
                var startDate = request.FromDate.Value;
                var endDate = request.ToDate.Value;

                DateTime minDate = new DateTime(startDate.Year, startDate.Month, startDate.Day, 0, 0, 0);
                DateTime maxDate = new DateTime(endDate.Year, endDate.Month, endDate.Day, 23, 59, 59);

                capaRequests = auditRepository.All
                    .Where(c => c.CreatedDate >= minDate && c.CreatedDate <= maxDate);
            }
            else
            {
                capaRequests = auditRepository.All;
            }

            var auditStatusOverview = await capaRequests
               .GroupBy(a => a.Status)
               .Select(g => new NameCountDto
               {
                   Name = g.Key.ToString(),
                   Count = g.Count()
               })
               .ToListAsync(cancellationToken);

            return auditStatusOverview;
        }
        catch (Exception ex)
        {
            logger.LogError(ex, "Error occurred while handling GetAuditStatusOverviewCommand");
            return new List<NameCountDto>();
        }
    }
}
