﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAllAuditCommandHandler(IAuditRepository auditRepository) : IRequestHandler<GetAllAuditCommand, AuditList>
{
    public async Task<AuditList> Handle(GetAllAuditCommand request, CancellationToken cancellationToken)
    {
        return await auditRepository.GetAudits(request.auditResource);
    }
}
