﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAllAuditForReviewCommandHandler(IAuditRepository auditRepository) : IRequestHandler<GetAllAuditForReviewCommand, AuditList>
{
    public async Task<AuditList> Handle(GetAllAuditForReviewCommand request, CancellationToken cancellationToken)
    {
        return await auditRepository.GetAuditForReview(request.auditResource);
    }
}
