﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetAuditReviewersForNorificationCommand : IRequest<ServiceResponse<List<AuditReviewNotification>>>
{

}

public class GetAuditReviewersForNorificationCommandHandler(
       IAuditReviewerRepository auditReviewerRepository,
       UserInfoToken userInfoToken
    ) : IRequestHandler<GetAuditReviewersForNorificationCommand, ServiceResponse<List<AuditReviewNotification>>>
{
    public async Task<ServiceResponse<List<AuditReviewNotification>>> Handle(GetAuditReviewersForNorificationCommand request, CancellationToken cancellationToken)
    {
        var reviewers = await auditReviewerRepository.All
        .Include(c => c.Audit)
        .Include(c => c.Submitter)
        .Where(c => c.Audit.Status == AUDIT_STATUS.INREVIEW && c.AuditStatus == AUDIT_STATUS.INREVIEW && c.ReviewerId == userInfoToken.Id)
        .Select(c => new AuditReviewNotification
        {
            Id = c.Id,
            AuditId = c.AuditId,
            Title = c.Audit.Title,
            Comments = c.Comments,
            ReviewedOn = c.ReviewedOn,
            AuditStatus = c.AuditStatus,
            SubmitterName = c.Submitter != null ? $"{c.Submitter.FirstName} {c.Submitter.LastName}" : ""
        })
        .ToListAsync();
        return ServiceResponse<List<AuditReviewNotification>>.ReturnResultWith200(reviewers);
    }
}

