﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Linq;
using System.Linq.Dynamic.Core;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetQuestionResponseByQuestionIdCommandHandler(IAuditResponseRepository auditResponseRepository, IMapper _mapper) : IRequestHandler<GetQuestionResponseByQuestionIdCommand, AuditResponseDto>
{
    public async Task<AuditResponseDto> Handle(GetQuestionResponseByQuestionIdCommand request, CancellationToken cancellationToken)
    {
        var entity = await auditResponseRepository.All
                    .Include(c => c.AuditResponseAttachments)
                        .ThenInclude(a => a.AuditResponseAttachmentChunks)
                    .Include(c => c.NonConformances)
                    .Include(c => c.CapaRequests)
                    .Where(c => c.QuestionId == request.QuestionId && c.AuditId == request.AuditId)
                    .FirstOrDefaultAsync(cancellationToken);
        if (entity == null)
        {
            return null;
        }
        var dto = _mapper.Map<AuditResponseDto>(entity);

        if (dto.AuditResponseAttachments != null && entity.AuditResponseAttachments != null)
        {
            for (int i = 0; i < dto.AuditResponseAttachments.Count; i++)
            {
                var chunkCount = entity.AuditResponseAttachments[i].AuditResponseAttachmentChunks?.Count ?? 0;
                dto.AuditResponseAttachments[i].TotalChunk = chunkCount;
            }
        }
        return dto;
    }
}
