﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
internal class GetQuestionResponseWithAttachmentByQuestionIdComandHandler(
    IAuditResponseRepository auditResponseRepository,
    IMapper mapper) : IRequestHandler<GetQuestionResponseWithAttachmentByQuestionIdComand, AuditResponseDto>
{
    public async Task<AuditResponseDto> Handle(GetQuestionResponseWithAttachmentByQuestionIdComand request, CancellationToken cancellationToken)
    {
        var entity = await auditResponseRepository.All
            .Include(c => c.AuditResponseAttachments)
            .Where(c => c.QuestionId == request.QuestionId)
            .FirstOrDefaultAsync(cancellationToken);
        if (entity == null)
        {
            return null; // or throw an exception if you prefer
        }
        return mapper.Map<AuditResponseDto>(entity);
    }
}
