﻿using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class SaveAuditResponseAttachmentCommandHandler(
        IAuditResponseRepository _auditResponseRepository,
        IAuditResponseAttachmentRepository auditResponseAttachmentRepository,
        IStorageSettingRepository _storageSettingRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<SaveAuditResponseAttachmentCommandHandler> _logger
    ) : IRequestHandler<SaveAuditResponseAttachmentCommand, ServiceResponse<AuditResponseAttachmentDto>>
{
    public async Task<ServiceResponse<AuditResponseAttachmentDto>> Handle(SaveAuditResponseAttachmentCommand request, CancellationToken cancellationToken)
    {
        try
        {

            var existResponse = await _auditResponseRepository.FindAsync(request.AuditResponseId);
            if (existResponse == null)
            {
                return ServiceResponse<AuditResponseAttachmentDto>.Return404("AuditResponseAttachment not found");
            }

            var storeageSetting = await _storageSettingRepository.GetStorageSettingByIdOrLocal(null);
            var keyValut = KeyGenerator.GenerateKeyAndIV();
            var entity = _mapper.Map<AuditResponseAttachment>(request);

            entity.Key = storeageSetting.EnableEncryption ? keyValut.Item1 : null;
            entity.IV = storeageSetting.EnableEncryption ? keyValut.Item2 : null;
           
            //entity.StorageType = storeageSetting.StorageType;
            entity.StorageSettingId = storeageSetting.Id;

            auditResponseAttachmentRepository.Add(entity);

            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<AuditResponseAttachmentDto>.Return500();
            }
            var entityDto = _mapper.Map<AuditResponseAttachmentDto>(entity);
            return ServiceResponse<AuditResponseAttachmentDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while saving AuditResponseAttachment");
            return ServiceResponse<AuditResponseAttachmentDto>.Return500("Error while saving AuditResponseAttachment");
        }
    }
}
