﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAuditResponseLogListCommandHandler(
        IAuditResponseLogRepository auditResponseLogRepository) : IRequestHandler<GetAuditResponseLogListCommand, AuditResponseLogList>
{
    public async Task<AuditResponseLogList> Handle(GetAuditResponseLogListCommand request, CancellationToken cancellationToken)
    {
        return await auditResponseLogRepository.GetAuditResponseLogs(request.AuditResponseResource);
    }
}
