﻿using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class GetReviewersByAuditIdCommand : IRequest<ServiceResponse<List<AuditReviewerDto>>>
{
    public Guid AuditId { get; set; }
}

public class GetReviewersByAuditIdCommandHandler(
     IAuditReviewerRepository _auditReviewerRepository,
     IMapper _mapper
    ) : IRequestHandler<GetReviewersByAuditIdCommand, ServiceResponse<List<AuditReviewerDto>>>
{

    public async Task<ServiceResponse<List<AuditReviewerDto>>> Handle(GetReviewersByAuditIdCommand request, CancellationToken cancellationToken)
    {
        var reviewers = await _auditReviewerRepository.All
            .Include(c => c.Reviewer)
            .Include(c => c.Submitter)
            .OrderByDescending(c => c.ReviewedOn)
            .Where(c => c.AuditId == request.AuditId)
            .ToListAsync(cancellationToken);
        var dtos = _mapper.Map<List<AuditReviewerDto>>(reviewers);
        return ServiceResponse<List<AuditReviewerDto>>.ReturnResultWith200(dtos);
    }
}
