﻿using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class AddAuditTemplateCommandHandler(
    IAuditTemplateRepository _auditTemplateRepository,
    IMapper _mapper,
    IUnitOfWork<QMSDbContext> _uow,
    ILogger<AddAuditTemplateCommandHandler> _logger) : IRequestHandler<AddAuditTemplateCommand, ServiceResponse<AuditTemplateDto>>
{
    public async Task<ServiceResponse<AuditTemplateDto>> Handle(AddAuditTemplateCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var existingName = await _auditTemplateRepository.All
               .Where(d => d.Name.ToLower() == request.Name.ToLower())
               .FirstOrDefaultAsync();
            if (existingName != null)
            {
                return ServiceResponse<AuditTemplateDto>.Return409("AuditTemplate name is already exist");
            }

            var entity = _mapper.Map<AuditTemplate>(request);
            _auditTemplateRepository.Add(entity);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<AuditTemplateDto>.Return500();
            }

            var entityDto = _mapper.Map<AuditTemplateDto>(entity);
            return ServiceResponse<AuditTemplateDto>.ReturnResultWith201(entityDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while saving AuditTemplate");
            return ServiceResponse<AuditTemplateDto>.Return500("Error while saving AuditTemplate");
        }
    }
}
