﻿using System.Threading;
using System.Threading.Tasks;
using MediatR;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAllAuditTemplateCommandHandler(
    IAuditTemplateRepository _auditTemplateRepository
    ) : IRequestHandler<GetAllAuditTemplateCommand, AuditTemplateList>
{
    public async Task<AuditTemplateList> Handle(GetAllAuditTemplateCommand request, CancellationToken cancellationToken)
    {
        return await _auditTemplateRepository.GetAuditTemplates(request.auditTemplateResource);
    }

}
