﻿using MediatR;
using QualityManagement.Data;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;
using System;
using System.ComponentModel.DataAnnotations.Schema;

namespace QualityManagement.MediatR;
public class AddCapaActionCommand:IRequest<ServiceResponse<CapaActionDto>>
{
    public Guid CapaRequestId { get; set; }
    public CapaActionType ActionType { get; set; }
    public string ActionDescription { get; set; }
    public Guid? AssignToId { get; set; }
    public CapaActionStatus Status { get; set; }
    public DateTime? DueDate { get; set; }
    public DateTime? CompletedDate { get; set; }
}
