﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR;
public class AddCapaActionCommandValidator:AbstractValidator<AddCapaActionCommand>
{
    public AddCapaActionCommandValidator()
    {
        RuleFor(c => c.CapaRequestId).Must(GuidNotEmpty).WithMessage("CapaRequest id is required");
    }
    private bool GuidNotEmpty(Guid p)
    {
        return p != Guid.Empty;
    }
}
