﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR;
public class DeleteCapaActionCommandHandler(
    ICapaActionRepository _capaActionRepository,
    IUnitOfWork<QMSDbContext> _uow,
    ILogger<DeleteCapaActionCommandHandler> _logger) : IRequestHandler<DeleteCapaActionCommand, ServiceResponse<bool>>
{
    public async Task<ServiceResponse<bool>> Handle(DeleteCapaActionCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entityExist = await _capaActionRepository.FindAsync(request.Id);
            if (entityExist == null)
            {
                return ServiceResponse<bool>.Return404("CapaAction not found");
            }
            _capaActionRepository.Delete(entityExist);
            if (await _uow.SaveAsync(cancellationToken) < 0)
            {
                return ServiceResponse<bool>.Return500();
            }
            return ServiceResponse<bool>.ReturnResultWith200(true);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while deleting CapaAction");
            return ServiceResponse<bool>.Return500("Error while deleting CapaAction");
        }
       

    }
}
