﻿using AutoMapper;
using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddCapaAttechmentCommandHandler(
        ICapaRequestRepository _capaRequestRepository,
        ICapaAttachmentRepository _capaAttachmentRepository,
        IMapper _mapper,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<AddCapaAttechmentCommandHandler> _logger,
        IStorageSettingRepository _storageSettingRepository) : IRequestHandler<AddCapaAttechmentCommand, ServiceResponse<CapaAttachmentDto>>
    {
        public async Task<ServiceResponse<CapaAttachmentDto>> Handle(AddCapaAttechmentCommand request, CancellationToken cancellationToken)
        {

            try
            {
                var existCapaRequest = await _capaRequestRepository.FindAsync(request.CapaRequestId);
                if (existCapaRequest == null)
                {
                    return ServiceResponse<CapaAttachmentDto>.Return404("CapaRequest not found");
                }
                var storeageSetting = await _storageSettingRepository.GetStorageSettingByIdOrLocal(null);
                var keyValut = KeyGenerator.GenerateKeyAndIV();
                var entity = _mapper.Map<CapaAttachment>(request);
                entity.Key = storeageSetting.EnableEncryption ? keyValut.Item1 : null;
                entity.IV = storeageSetting.EnableEncryption ? keyValut.Item2 : null;
                entity.StorageSettingId = storeageSetting.Id;

                _capaAttachmentRepository.Add(entity);

                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<CapaAttachmentDto>.Return500();
                }
                var entityDto = _mapper.Map<CapaAttachmentDto>(entity);
                return ServiceResponse<CapaAttachmentDto>.ReturnResultWith201(entityDto);
            }
            catch (System.Exception ex)
            {
                _logger.LogError(ex, "Error while saving CapaAttachment");
                return ServiceResponse<CapaAttachmentDto>.Return500("Error while saving CapaAttachment");
            }
        }
    }
}
