﻿using FluentValidation;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class AddCapaAttechmentCommandValidator:AbstractValidator<AddCapaAttechmentCommand>
    {
        public AddCapaAttechmentCommandValidator()
        {
            RuleFor(c => c.CapaRequestId).Must(GuidNotEmpty).WithMessage("CapaRequest id is required");
        }
        private bool GuidNotEmpty(Guid p)
        {
            return p != Guid.Empty;
        }

    }
}
