﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAllCapaAttachmentByCapaRequestIdCommandHandler(
   ICapaAttachmentRepository capaAttachmentRepository,
   IMapper _mapper,
   ILogger<GetActionQueryHandlerHandler> _logger) : IRequestHandler<GetAllCapaAttachmentByCapaRequestIdCommand, ServiceResponse<List<CapaAttachmentDto>>>
{
    public async Task<ServiceResponse<List<CapaAttachmentDto>>> Handle(GetAllCapaAttachmentByCapaRequestIdCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entity = await capaAttachmentRepository.All.Where(d => d.CapaRequestId == request.CapaRequestId).ToListAsync();
            var entityDto = _mapper.Map<List<CapaAttachmentDto>>(entity);
            return ServiceResponse<List<CapaAttachmentDto>>.ReturnResultWith201(entityDto);
        }
        catch (Exception ex)
        {
            _logger.LogError(ex, "Error occurred while getting capa attachment by capa request ID: {CapaRequestId}", request.CapaRequestId);
            return ServiceResponse<List<CapaAttachmentDto>>.Return500("An error occurred while processing the request.");
        }
    }
}
