﻿using System;
using MediatR;
using QualityManagement.Data.Dto;
using QualityManagement.Data.Entities;
using QualityManagement.Helper;

namespace QualityManagement.MediatR;

public class AddCapaRequestCommand : IRequest<ServiceResponse<CapaRequestDto>>
{
    public string Title { get; set; }
    public string Description { get; set; }
    public Guid? RaisedById { get; set; }
    public Guid? NonConformanceId { get; set; }
    public Guid? AuditId { get; set; }
    public Guid? AuditResponseId { get; set; }
    public CapaRequestStatus CapaRequestStatus { get; set; }
    public CapaRequestPriority Priority { get; set; }
    public DateTime? DueDate { get; set; }
}
