﻿using MediatR;
using Microsoft.Extensions.Logging;
using QualityManagement.Common.UnitOfWork;
using QualityManagement.Domain;
using QualityManagement.Helper;
using QualityManagement.Repository;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class DeleteCapaRequestCommandHandler(
        ICapaRequestRepository _capaRequestRepository,
        IUnitOfWork<QMSDbContext> _uow,
        ILogger<DeleteCapaRequestCommandHandler> _logger) : IRequestHandler<DeleteCapaRequestCommand, ServiceResponse<bool>>
    {
        public async Task<ServiceResponse<bool>> Handle(DeleteCapaRequestCommand request, CancellationToken cancellationToken)
        {
            try
            {
                var entityExist = await _capaRequestRepository.FindAsync(request.Id);
                if (entityExist == null)
                {
                    return ServiceResponse<bool>.Return404("CapaRequest not found");
                }
                _capaRequestRepository.Delete(entityExist);
                if (await _uow.SaveAsync(cancellationToken) < 0)
                {
                    return ServiceResponse<bool>.Return500();
                }
                return ServiceResponse<bool>.ReturnResultWith200(true);
            }
            catch (System.Exception ex)
            {

                _logger.LogError(ex, "Error while Deleting CapaRequest");
                return ServiceResponse<bool>.Return500("Error while Deleting CapaRequest");
            }

        }
    }
}
