﻿using MediatR;
using Microsoft.EntityFrameworkCore;
using NPOI.SS.Formula.Functions;
using QualityManagement.Data.Entities;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR.Capa
{
    public class GetCapaClosureRateCommandHandler(
        ICapaRequestRepository _capaRequestRepository) : IRequestHandler<GetCapaClosureRateCommand, decimal>
    {
        public async Task<decimal> Handle(GetCapaClosureRateCommand request, CancellationToken cancellationToken)
        {
            var totalCapa = await _capaRequestRepository
                .All
                .Where(c=>c.CapaRequestStatus == CapaRequestStatus.OPEN || c.CapaRequestStatus==CapaRequestStatus.CLOSED)
                .Select(c=> new
                {
                    c.CapaRequestStatus
                }).ToListAsync();

            var capaClosed = totalCapa.Where(c => c.CapaRequestStatus == CapaRequestStatus.CLOSED).Count();
            var capaRaised = totalCapa.Where(c => c.CapaRequestStatus == CapaRequestStatus.OPEN).Count();
            if (capaClosed == 0 || capaRaised == 0)
            {
                return 0;
            }
            decimal closureRate = Math.Round(((decimal)capaClosed / capaRaised) * 100, 2);
            return closureRate;
        }
    }
}
