﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using MediatR;
using Microsoft.EntityFrameworkCore;
using QualityManagement.Data.Dto;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;
public class GetAllCapaRequestAuditsCommandHandler(ICapaRequestRepository capaRequestRepository) : IRequestHandler<GetAllCapaRequestAuditsCommand, List<IdNameDto>>
{
    public async Task<List<IdNameDto>> Handle(GetAllCapaRequestAuditsCommand request, CancellationToken cancellationToken)
    {
        return await capaRequestRepository.All.Include(x => x.Audit).IgnoreQueryFilters()
            .Where(x => x.AuditId != null)
            .Select(x => new IdNameDto
            {
                Id = x.Audit.Id,
                Name = x.Audit.Title,
            })
            .Distinct()
            .ToListAsync();
    }
}