﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class UpdateCapaRequestCommandValidator : AbstractValidator<UpdateCapaRequestCommand>
    {
        public UpdateCapaRequestCommandValidator()
        {
            RuleFor(c => c.Id).Must(NotEmptyGuid).WithMessage("CapaRequest id is required");
            RuleFor(c => c.Title).NotEmpty().WithMessage("Title is required");
        }
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }
    }
}
