﻿using MediatR;
using QualityManagement.Repository;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace QualityManagement.MediatR
{
    public class GetCapaRequestLogListCommandHandler (
        ICapaRequestLogRepository _capaRequestLogRepository) : IRequestHandler<GetCapaRequestLogListCommand, CapaRequestLogList>
    {
        public async Task<CapaRequestLogList> Handle(GetCapaRequestLogListCommand request, CancellationToken cancellationToken)
        {
            return await _capaRequestLogRepository.GetCapaRequestLog(request.CapaRequestLogResource);
        }
    }
}
