﻿using FluentValidation;
using System;

namespace QualityManagement.MediatR
{
    public class AddCapaReviewCommandValidator : AbstractValidator<AddCapaReviewCommand>
    {
        public AddCapaReviewCommandValidator()
        {
            RuleFor(c => c.CapaRequestId).Must(NotEmptyGuid).WithMessage("CapaRequest id is required");
            RuleFor(c => c.ReviewComment).NotEmpty().WithMessage("ReviewComment is required");
        }
        private bool NotEmptyGuid(Guid p)
        {
            return p != Guid.Empty;
        }

    }
}
