﻿using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetCapaReviewCommandHandler(
    ICapaReviewRepository _capaReviewRepository,
    ILogger<GetCapaReviewCommandHandler> _logger,
    IMapper _mapper) : IRequestHandler<GetCapaReviewCommand, ServiceResponse<List<CapaReviewDto>>>
{
    public async Task<ServiceResponse<List<CapaReviewDto>>> Handle(GetCapaReviewCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await _capaReviewRepository
                .All
                .Include(c => c.ReviewedBy)
                .Where(c => c.CapaRequestId == request.Id)
                .ToListAsync();
            var entitiesDto = _mapper.Map<List<CapaReviewDto>>(entities);
            return ServiceResponse<List<CapaReviewDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while getting CapaReview");
            return ServiceResponse<List<CapaReviewDto>>.Return500("Error while getting CapaReview");
        }
    }
}
