﻿using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using AutoMapper;
using MediatR;
using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Logging;
using QualityManagement.Data.Dto;
using QualityManagement.Helper;
using QualityManagement.Repository;

namespace QualityManagement.MediatR;

public class GetAllCapaRootCauseMethodologyCommandHandler(
    ICapaRootCauseMethodologyRepository _capaRootCauseMethodologyRepository,
    IMapper _mapper,
    ILogger<GetAllCapaRootCauseMethodologyCommandHandler> _logger) : IRequestHandler<GetAllCapaRootCauseMethodologyCommand, ServiceResponse<List<CapaRootCauseMethodologyDto>>>
{
    public async Task<ServiceResponse<List<CapaRootCauseMethodologyDto>>> Handle(GetAllCapaRootCauseMethodologyCommand request, CancellationToken cancellationToken)
    {
        try
        {
            var entities = await _capaRootCauseMethodologyRepository.All.ToListAsync(cancellationToken);
            var entitiesDto = _mapper.Map<List<CapaRootCauseMethodologyDto>>(entities);
            return ServiceResponse<List<CapaRootCauseMethodologyDto>>.ReturnResultWith200(entitiesDto);
        }
        catch (System.Exception ex)
        {
            _logger.LogError(ex, "Error while get All CapaRootCauseMethodology");
            return ServiceResponse<List<CapaRootCauseMethodologyDto>>.Return500();
        }

    }
}
